// Persistence of Vision Ray Tracer Scene Description File
// File: Front Cover.pov
// Vers: 3.5
// Desc: Defeated but Unbroken Front Cover
// Date: 9/3/02
// Auth: Brian Jackson 

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	  // Standard Color definitions
#include "textures.inc"	  // Standard Texture definitions
#include "functions.inc"  // internal functions usable in user defined functions

sky_sphere {pigment {
        granite
        color_map {
            [ 0.000  0.270 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.270  0.280 color rgb <.5,.5,.4> color rgb <.8,.8,.4> ]
            [ 0.280  0.470 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.470  0.480 color rgb <.4,.4,.5> color rgb <.4,.4,.8> ]
            [ 0.480  0.680 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.680  0.690 color rgb <.5,.4,.4> color rgb <.8,.4,.4> ]
            [ 0.690  0.880 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.880  0.890 color rgb <.5,.5,.5> color rgb < 1, 1, 1> ]
            [ 0.890  1.000 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
        }
    turbulence 1
    sine_wave
    scale .5
    }
}

camera {location <0,0,-10> look_at <0,0,0>}
light_source {<5,0,-10> color White}
light_source {<5,0,-10.5> color White}

sphere {<0,0,0>,2.5 pigment {bozo turbulence 1 color_map {[0 color Blue][0.95 color Green]}}}
sphere {<0,0,0>,2.55 pigment {wrinkles turbulence 0 color_map {[0 color rgbt <0,0,0,1>][0.9 color White][1 color rgbt <0,0,0,1>]}}}
sphere {<0,1.5,5>,0.5 pigment {granite color_map {[0 color White][0.25 color Gray][0.75 color DimGray]}} rotate y*225}
cylinder {<15,0,0>,<-15,0,0>,0.1 pigment {color Red} finish {ambient 1} finish {ambient 1} rotate z*45}
cylinder {<15,0,0>,<-15,0,0>,0.2 pigment {granite color_map {[0 color rgbt <0,0,0,1>][0.75 color rgbt <1,0,0,0.125>][1 color rgbt <0,0,0,1>]}} finish {ambient 1} rotate z*45}
cone {<0,2.5,0>,0.25 <0,3,0>,0.75 pigment {granite turbulence 0.75 color_map {[0 color rgbt <0,0,0,1>][0.5 color rgbt <1,1,1,0.25>][1 color rgbt <0,0,0,1>]}} rotate z*-45}

text {ttf "Bnkgothm.ttf", "Defeated but Unbroken", 0.125, 0 pigment {color Gray} finish {ambient 1} no_shadow scale <0.625,0.625,1> translate <-3,-3.75,-1.25>}
text {ttf "Bnkgothm.ttf", "Brian Jackson", 0.125, 0 pigment {color Gray} finish {ambient 1} no_shadow scale <0.75,0.75,1> translate <-5,3,-1.25>}
